function [b]=udpprogflash(skt,add,data)
%function [b]=udpprogflash(skt,add,data)
% Low level function for programming flash variables on PIC
% THIS IS CRUDE AND NEEDS WORK
% restricted to max udp packet size - 10
% updated for octave 4-Feb-2018 - Ian Stothers
% 2-Nov-2024 updated for serial fixes - Ian Stothers

if (isfield(skt,'ser')==1)
  [b]=serprogflash(skt,add,data);
else

 if (skt.bits==32)
  oldskt_Timeout=skt.udp.Timeout;
  skt.udp.Timeout=1;
  key=12345.0;
  keyb=[uint8(bitand(key,255)) uint8(key/256.0)];
  sd=size(data);
  sd=sd(1)*sd(2);
  extrabytes=(ceil(sd/4)*4)-sd;
  data=[reshape(data,1,sd) uint8(zeros(1,extrabytes))];
  sd=size(data);
  sd=sd(1)*sd(2);
  ptr=1;
  for ul=1:floor(sd/4)
   addb=uint8([bitand(floor(add),255) bitand(floor(add/(2^8)),255) bitand(floor(add/(2^16)),255) bitand(floor(add/(2^24)),255) ]);
   pbuf=uint8([21 1 2 3  4 0 0 0  addb   data(ptr) data(ptr+1)  data(ptr+2) data(ptr+3)  ]);
   flushinput(skt.udp);

   write(skt.udp,pbuf,skt.ip,skt.port);
   flushoutput(skt.udp);
   read(skt.udp,8);
   add=add+4;
   ptr=ptr+4;
  end
  skt.udp.Timeout=oldskt_Timeout;
 else

  if (add<=65536)
   add=bitand(add,hex2dec('7fff')); % lose MSB if this is data memory reference of prog mem
  end
  key=12345.0;
  keyb=[uint8(bitand(key,255)) uint8(key/256.0)];
  sd=size(data);
  sd=sd(1)*sd(2);
  extrabytes=(ceil(sd/4)*4)-sd;
  data=[reshape(data,1,sd) uint8(zeros(1,extrabytes))];
  sd=size(data);
  sd=sd(1)*sd(2);
  ptr=1;
  for ul=1:floor(sd/4)
   addb=uint8([bitand(add,255) double(add)/256.0 ]);
   pbuf=uint8([11 0 0 0 keyb  addb 0 0  data(ptr) data(ptr+1) 0  255 data(ptr+2) data(ptr+3)  0  255 ]);
   write(skt.udp,pbuf,skt.ip,skt.port);
   flushoutput(skt.udp);
   read(skt.udp,8);
   add=add+4;
   ptr=ptr+4;
  end
 endif
 b=1;
 %  pause(1);
endif
endfunction

function [b]=serprogflash(skt,add,data)
%function [b]=serprogflash(skt,add,data)
% Low level function for programming flash variables on STM
% THIS IS CRUDE AND NEEDS WORK
% 7-Jun- 2023 - Ian Stothers
%
 pp_commands;
 oldto=skt.ser.Timeout;
 skt.ser.Timeout=0.25; %longer timeout to allow for erase
 sd=size(data);
 sd=sd(1)*sd(2);
 extrabytes=(ceil(sd/4)*4)-sd;
 data=[reshape(data,1,sd) uint8(zeros(1,extrabytes))];
 sd=size(data);
 sd=sd(1)*sd(2);

 ok=1;
 op=[];
 len=prod(size(data));
 dptr=0;
 data=bitand(data(:)',255);
 while (len>0)
      toget=min([len 4]);
      toget=min([toget skt.max]);
      pbuf=uint8([UDP_ERASE_PROG_FLASH bitand(toget,255)]);
      pbuf=[pbuf  bitand(add,255) bitand(floor(add/2.^8),255) bitand(floor(add/2.^16),255) bitand(floor(add/2.^24),255)];
      pbuf=[pbuf  data((1:toget)+dptr)];
      bb=sersendget(skt,pbuf,PPHSIZE,1);
      if (max(size(bb))==PPHSIZE)
        if ((bb(1:4)==[UDP_ERASE_PROG_FLASH_REPLY])&&(toget==bb(5)))
           dptr=dptr+toget;
           len=len-toget;
           add=add+toget;
        end

      end

 end %while len
 b=1;
 skt.ser.Timeout=oldto;

endfunction


